<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBMods - HelpDesk v1.55
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'helpdesk_install');
define('NO_REGISTER_GLOBALS', 1);
define('VERSION', '1.54');

require_once('./global.php');
require_once('./includes/adminfunctions_template.php');
require_once('./includes/adminfunctions_language.php');

$step = $_REQUEST['step'];

print_cp_header('HelpDesk v'.VERSION, '', "<style type=\"text/css\">
<!--
.redalert
{
        background: #FF0000;
        color: #000000;
}
-->
</style>");

if (empty($_REQUEST['do']) OR !$_REQUEST['do'])
{
        $_REQUEST['do'] = 'install';
}

if (empty($step))
        $step = '0';

// Make Template Function
function insert_template($name, $content)
{
        global $DB_site;

        $template = compile_template($content);

        $DB_site->query("REPLACE INTO " . TABLE_PREFIX . "template (templateid, title, template, template_un, styleid, templatetype, dateline, username, version) VALUES (NULL, '$name', '" . addslashes($template) . "', '" . addslashes($content) ."', '-1', 'template', '" . time() . "', 'Geeky Designs', '3.0.0')");

        echo "<font size=\"1\">/  - $name </font><br />";
}

// Delete Template Function
function kill_template($title)
{
        global $DB_site;

        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$title'");
        echo "  $title<br />";
}

// Insert Phrase Function
function insert_phrase($varname, $text, $phrasetype)
{
        global $DB_site, $phrase;

        $DB_site->query("REPLACE INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0', '" . $varname . "', '" . addslashes($text) ."', '$phrasetype')");

        if ($phrasetype == 3000)
        {
                echo "<font size=\"1\">/  - $varname</font><br />";
                $text = $phrase[$varname]['subject'];
                $phrasetype = 4000;
                $DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0', '" . $varname . "', '" . addslashes($text) ."', '$phrasetype')");
        }
        echo "<font size=\"1\">/  - $varname</font><br />";
}

// Insert Phrase Function
function kill_phrase($varname)
{
        global $DB_site;

        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = '" . addslashes($varname) . "'");
        echo "<font size=\"1\">  - $varname</font><br />";
}

// Insert Settings Function
function insert_setting($title, $description, $varname, $grouptitle, $value, $defaultvalue, $optioncode, $displayorder)
{
        global $DB_site;

        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0', 'setting_" . $varname . "_title', '" . addslashes($title) ."', '5000')");
        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0',  'setting_" . $varname . "_desc', '" . addslashes($description) ."', '5000')");
        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "setting (varname, grouptitle, value, defaultvalue, optioncode, displayorder, advanced, volatile) VALUES ('$varname', '$grouptitle', '$value', '$defaultvalue', '".addslashes($optioncode)."', '$displayorder', '0', '0')");
        echo "<font size=\"1\">  - $title </font><br />";
}

// Delete Setting Function
function kill_setting($title)
{
        global $DB_site;

        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $title . "_title'");
        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $title . "_desc'");
        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "setting WHERE varname = '$title'");
        echo "<font size=\"1\">  - $title </font><br />";
}

// ##################### Template Content ###########################
$templates['HELPDESK_SHELL'] = '$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
        <title>$vboptions[bbtitle] - $pagetitle</title>
$headinclude
</head>
<body$onload>
$header
$navbar

<!-- table to support left column nav -->
<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
<tr valign="top">
<td>

<!-- helpdesk nav -->
<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0">
<tr>
        <td class="tcat"><a href="helpdesk.php?$session[sessionurl]">$vbphrase[helpdesk]</a></td>
</tr>
<if condition="$departmentaccess == 1">
        <tr>
                <td class="thead">$vbphrase[helpdesk] $vbphrase[options]</td>
        </tr>
        <tr>
                <td class="$navclass[departments]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=departments">$vbphrase[departments]</a></td>
        </tr>
        <tr>
                <td class="$navclass[usergroup]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=usergroup">$vbphrase[usergroup_settings]</a></td>
        </tr>
</if>
<if condition="is_array($administeraccess)">
        <tr>
                <td class="thead">$vbphrase[administer]</td>
        </tr>
        <tr>
                <td class="$navclass[mytickets]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=mytickets">$vbphrase[my_tickets]</a></td>
        </tr>
        <tr>
                <td class="$navclass[unresolvedtickets]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=unresolvedtickets">$vbphrase[unresolved_tickets]</a></td>
        </tr>
        <tr>
                <td class="$navclass[resolvedtickets]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=resolvedtickets">$vbphrase[resolved_tickets]</a></td>
        </tr>
        <tr>
                <td class="$navclass[newtickets]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=newtickets">$vbphrase[new_tickets]</a></td>
        </tr>
        <tr>
                <td class="$navclass[newreplies]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=newreplies">$vbphrase[new_replies]</a></td>
        </tr>
</if>
<tr>
        <td class="thead">$vbphrase[user_controls]</td>
</tr>
<if condition="$vboptions[\'helpdesk_new_tickets\'] == 1 && $userpermissions[\'can_create_ticket\']">
        <tr>
                <td class="$navclass[newticket]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=newticket">$vbphrase[new_ticket]</a></td>
        </tr>
</if>
<tr>
        <td class="$navclass[unresolved]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=unresolved">$vbphrase[unresolved_tickets]</a></td>
</tr>
<tr>
        <td class="$navclass[resolved]" nowrap="nowrap"><a class="smallfont" href="helpdesk.php?$session[sessionurl]do=resolved">$vbphrase[resolved_tickets]</a></td>
</tr>
</table>
<!-- / helpdesk nav -->

</td>
<td>&nbsp;&nbsp;</td>
<td width="100%">

<!-- main page contents -->
$HTML
<!-- / main page contents -->

</td>
</tr>
</table>
<!-- / table to support left column nav -->
$footer
</body>
</html>';

$templates['helpdesk_message'] = '        <tr>
                <td class="$bgclass" colspan="5" align="center">$message</td>
        </tr>';

$templates['helpdesk_newticket'] = '<form action="helpdesk.php" method="post" name="vbform"<if condition="!is_browser(\'webtv\')"> onsubmit="return validatePost(this, this.title.value, $vboptions[postminchars], $vboptions[postmaxchars]);" onreset="vB_RESET(this);"</if>>
<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<tr>
        <td class="tcat">$vbphrase[new_ticket]</td>
</tr>
<tr>
        <td class="panelsurround" align="center">
        <div class="panel">

                <!-- subject field -->
                <table cellpadding="0" cellspacing="0" border="0" class="fieldset">
                <tr>
                        <td class="smallfont" colspan="3" align="left">$vbphrase[title]:</td>
                </tr>
                <tr>
                        <td align="left"><input type="text" class="bginput" name="title" value="$title" size="40" maxlength="85" tabindex="1" /></td>
                </tr>
                <!-- / subject field -->

                <!-- department -->
                <tr>
                        <td class="smallfont" align="left">$vbphrase[department]:</td>
                </tr>
                <tr>
                        <td align="left">
                                <select name="departmentid">
                                        $departmentselect
                                </select>
                        </td>
                </tr>
                <!-- / department -->

                <tr>
                        <td>

                <!-- message area -->
                <div class="smallfont" align="left">$vbphrase[message]:</div>
                $messagearea
                <!-- / message area -->

                        </td>
                </tr>
                </table>

        </div>

        <div style="margin-top:$stylevar[cellpadding]px">
                <input type="hidden" name="s" value="$session[sessionhash]" />
                <input type="hidden" name="do" value="submitnewticket" />
                <input type="submit" class="button" name="sbutton" value="$vbphrase[submit_new_ticket]" accesskey="s" tabindex="1" />
        </div>
        </td>
</tr>
</table>
</form>';

$templates['helpdesk_quickreply'] = '<form action="helpdesk.php" method="post" name="vbform"<if condition="!is_browser(\'webtv\')"> onsubmit="return validatePost(this, 0, 0, 0);" onreset="vB_RESET(this);"</if>>
<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<tr>
        <td class="tcat">$vbphrase[ticket_reply]</td>
</tr>
<tr>
        <td class="panelsurround" align="center">
        <div class="panel">

                <table cellpadding="0" cellspacing="0" border="0" class="fieldset">
                <tr>
                        <td>

                <!-- message area -->
                $messagearea
                <!-- / message area -->

                        </td>
                </tr>
                </table>

        </div>

        <div style="margin-top:$stylevar[cellpadding]px">
                <input type="hidden" name="s" value="$session[sessionhash]" />
                <input type="hidden" name="do" value="ticketreply" />
                <input type="hidden" name="tid" value="$_REQUEST[tid]" />
                <input type="submit" class="button" name="sbutton" value="$vbphrase[reply_to_ticket]" accesskey="s" tabindex="1" />
        </div>
        </td>
</tr>
</table>
</form>';

$templates['helpdesk_reply'] = '<if condition="empty($HTML)">
<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center" style="border-bottom-width:0px">
<tr>
        <td class="tcat" width="100%">

                <div class="smallfont">$ticketmessage

                &nbsp;
                </div>
        </td>

        <td class="vbmenu_control" id="tickettools">
                <a href="#goto_tickettools">$vbphrase[ticket_tools]</a>
                <script type="text/javascript"> vbmenu_register("tickettools"); </script>
        </td>
</tr>
</table>

<div class="vbmenu_popup" id="tickettools_menu" style="display:none">
        <table cellpadding="4" cellspacing="1" border="0">
        <tr>

                <td class="thead">$vbphrase[ticket_tools]<a name="goto_tickettools"></a></td>
        </tr>
        <if condition="($reply[\'open\'] == 0 && $bbuserinfo[\'userid\'] == $reply[\'userid\'] && $userpermissions[\'can_unresolve_ticket\'] == 1) || ($userpermissions[\'can_unresolve_any_ticket\'] == 1 && $reply[\'open\'] == 0)">
                <tr>
                        <td class="vbmenu_option"><a href="helpdesk.php?$session[sessionurl]do=unresolveticket&tid=$_REQUEST[tid]">$vbphrase[unresolve_ticket]</a></td>
                </tr>
        </if>
        <if condition="($reply[\'open\'] == 1 && $bbuserinfo[\'userid\'] == $reply[\'userid\'] && $userpermissions[\'can_resolve_ticket\'] == 1) || ($userpermissions[\'can_resolve_any_ticket\'] == 1 && $reply[\'open\'] == 1)">
                <tr>
                        <td class="vbmenu_option"><a href="helpdesk.php?$session[sessionurl]do=resolveticket&tid=$_REQUEST[tid]">$vbphrase[resolve_ticket]</a></td>
                </tr>
        </if>
        <if condition="($bbuserinfo[\'userid\'] == $reply[\'userid\'] && $userpermissions[\'can_delete_ticket\'] == 1) || $userpermissions[\'can_delete_any_ticket\'] == 1">
                <tr>
                        <td class="vbmenu_option"><a href="helpdesk.php?$session[sessionurl]do=delete&tid=$_REQUEST[tid]">$vbphrase[delete_ticket]</a></td>
                </tr>
        </if>
        <if condition="$bbuserinfo[\'userid\'] == $reply[\'ownerid\'] && $userpermissions[\'can_unclaim_ownership\'] && is_array($administeraccess)">
        <tr>
                <td class="vbmenu_option"><a href="helpdesk.php?$session[sessionurl]do=unclaim&tid=$_REQUEST[tid]">$vbphrase[unclaim_ownership]</a></td>
        </tr>
        </if>
        <if condition="empty($reply[\'ownerid\']) && $userpermissions[\'can_claim_ownership\'] && is_array($administeraccess)">
                <tr>
                        <td class="vbmenu_option"><a href="helpdesk.php?$session[sessionurl]do=claim&tid=$_REQUEST[tid]">$vbphrase[claim_ownership]</a></td>
                </tr>
        </if>
        </table>
</div>
</if>

<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<thead>
        <tr>
                <td class="thead">
                        <span style="float: right;"><phrase 1="$reply[dateline]" 2="$reply[username]">$vbphrase[last_update_by]</phrase></span>
                        <if condition="!empty($HTML)">$vbphrase[reply_prefix] </if>$reply[title]
                        <if condition="($bbuserinfo[\'userid\'] == $reply[\'userid\'] && $userpermissions[\'can_edit_ticket\'] == 1) || $userpermissions[\'can_edit_any_ticket\'] == 1">
                                &nbsp; &nbsp;[<a href="helpdesk.php?$session[sessionurl]do=edit&rid=$reply[replyid]">$vbphrase[edit_reply]</a>]
                        </if>
                        </td>
        </tr>
</thead>
<tbody>
        <tr>
                <td class="$bgclass">$reply[pagetext]</td>
        </tr>
</tbody>
</table>
<div style="height: 6px;"></div>';

$templates['helpdesk_ticket'] = '        <tr>
                <td class="$bgclass" align="center">$ticket[postusername]</td>
                <td class="$bgclass" align="center"><a href="helpdesk.php?$session[sessionurl]do=ticket&tid=$ticket[ticketid]">$ticket[title]</a></td>
                <td class="$bgclass" align="center">$ticket[department]</td>
                <td class="$bgclass" align="center">$ticket[dateline]</td>
                <td class="$bgclass" align="center"><phrase 1="$ticket[lastupdate]" 2="$ticket[lastposter]">$vbphrase[last_update_by]</phrase></td>
        </tr>';

$templates['helpdesk_ticketlist'] = '<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<thead>
        <tr>
                <td class="tcat" colspan="5">$headertitle</td>
        </tr>
        <tr>
                <td class="thead" align="center">$vbphrase[posted_by]</td>
                <td class="thead" align="center">$vbphrase[title]</td>
                <td class="thead" align="center">$vbphrase[department]</td>
                <td class="thead" align="center">$vbphrase[when_logged]</td>
                <td class="thead" align="center">$vbphrase[last_update]</td>
        </tr>
</thead>
<tbody>
        $tickets
</tbody>
</table>';

$templates['helpdesk_usergroupsettings'] = '<form action="helpdesk.php" method="post">
<input type="hidden" name="s" value="$session[sessionhash]" />
<input type="hidden" name="do" value="saveusergroup" />
<input type="hidden" name="usergroupid" value="$_REQUEST[usergroupid]" />
<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<thead>
        <tr>
                <td class="tcat" colspan="2">$usergroup[title]</td>
        </tr>
</thead>
<tbody>
        $perms
        <tr>
                <td class="tfoot" colspan="2" align="center">
                        <input type="submit" value="$vbphrase[update] $vbphrase[usergroup]" class="button" />
                </td>
        </tr>
</tbody>
</table>
</form>';

$templates['helpdesk_usergroupradio'] = '        <tr>
                <td class="$bgclass" width="100%">$vbphrase[$perm]</td>
                <td class="$bgclass" align="right" nowrap="nowrap">$radioselect</td>
        </tr>';

$templates['helpdesk_usergrouplist'] = '<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<thead>
        <tr>
                <td class="tcat" colspan="3">$vbphrase[usergroup_settings]</td>
        </tr>
        <tr>
                <td class="thead" align="center">$vbphrase[id]</td>
                <td class="thead" align="center">$vbphrase[usergroup]</td>
                <td class="thead" align="center">$vbphrase[manage]</td>
        </tr>
</thead>
<tbody>
        $usergroups
</tbody>
</table>';

$templates['helpdesk_usergroup'] = '        <tr>
                <td class="$bgclass" align="center">$usergroup[usergroupid]</td>
                <td class="$bgclass" align="center">$usergroup[title]</td>
                <td class="$bgclass" align="center">
                        <form action="helpdesk.php" method="post">
                        <input type="hidden" name="s" value="$session[sessionhash]" />
                        <input type="hidden" name="do" value="updateusergroup" />
                        <input type="hidden" name="usergroupid" value="$usergroup[usergroupid]" />
                        <input type="submit" class="button" value="$vbphrase[manage]" />
                        </form>
                </td>
        </tr>';

$templates['helpdesk_replyedit'] = '<form action="helpdesk.php" method="post" name="vbform"<if condition="!is_browser(\'webtv\')"> onsubmit="return validatePost(this, this.title.value, $vboptions[postminchars], $vboptions[postmaxchars]);" onreset="vB_RESET(this);"</if>>
<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<tr>
        <td class="tcat">$vbphrase[edit_reply]</td>
</tr>
<tr>
        <td class="panelsurround" align="center">
        <div class="panel">

                <!-- subject field -->
                <table cellpadding="0" cellspacing="0" border="0" class="fieldset">
                <tr>
                        <td class="smallfont" align="left">$vbphrase[ticket] $vbphrase[title]:</td>
                </tr>
                <tr>
                        <td align="left"><input type="text" class="bginput" name="title" value="$reply[title]" size="40" maxlength="85" tabindex="1" /></td>
                </tr>
                <!-- / subject field -->

                <!-- department -->
                <tr>
                        <td class="smallfont" align="left">$vbphrase[department]:</td>
                </tr>
                <tr>
                        <td align="left">
                                <select name="departmentid">
                                        $departmentselect
                                </select>
                        </td>
                </tr>
                <!-- / department -->

                <tr>
                        <td>

                <!-- message area -->
                <div class="smallfont" align="left">$vbphrase[message]:</div>
                $messagearea
                <!-- / message area -->

                        </td>
                </tr>
                </table>

        </div>

        <div style="margin-top:$stylevar[cellpadding]px">
                <input type="hidden" name="s" value="$session[sessionhash]" />
                <input type="hidden" name="do" value="editreply" />
                <input type="hidden" name="rid" value="$_REQUEST[rid]" />
                <input type="submit" class="button" name="sbutton" value="$vbphrase[edit_reply]" accesskey="s" tabindex="1" />
        </div>
        </td>
</tr>
</table>
</form>';

$templates['helpdesk_departmentlist'] = '<form action="helpdesk.php" method="post">
<input type="hidden" name="s" value="$session[sessionhash]" />
<input type="hidden" name="do" value="adddepartment" />

<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<tr>
        <td class="tcat">$vbphrase[add_department]</td>
</tr>
<tr>
        <td class="panelsurround" align="center">

        <table class="panel" cellpadding="0" cellspacing="$stylevar[formspacer]" border="0" width="100%">
        <tr>
                <td align="$stylevar[left]">
                        <table cellpadding="0" cellspacing="$stylevar[formspacer]" border="0">
                        <tr>
                                <td colspan="2">
                                        <div>$vbphrase[department]:</div>
                                        <div><input type="text" class="bginput" name="department" size="35" maxlength="$vboptions[maxuserlength]" style="width:100%" /></div>
                                </td>
                        </tr>
                        </table>
                </td>
                <td align="$stylevar[left]">
                        <table cellpadding="0" cellspacing="$stylevar[formspacer]" border="0">
                        <tr>
                                <td colspan="2">
                                        <div>$vbphrase[display_order]:</div>
                                        <div><input type="text" class="bginput" name="displayorder" size="35" style="width:100%" /></div>
                                </td>
                        </tr>
                        </table>
                </td>
                <td align="$stylevar[left]">
                        <table cellpadding="0" cellspacing="$stylevar[formspacer]" border="0">
                        <tr>
                                <td colspan="2">
                                        <div>$vbphrase[usergroups]:</div>
                                        <div><input type="text" class="bginput" name="usergroups" size="35" style="width:100%" /></div>
                                </td>
                        </tr>
                        </table>
                </td>
        </tr>
        </table>
        </div>

        <div style="margin-top:$stylevar[cellpadding]px">
                <input type="submit" class="button" name="dosearch" value="$vbphrase[add_department]" accesskey="s" />
        </div>

        </div>
        </td>
</tr>
</table>

</form>

<br />

<table class="tborder" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" border="0" width="100%" align="center">
<thead>
        <tr>
                <td class="tcat" colspan="4">
                        <span style="float: right;">$message</span>
                        $vbphrase[departments]
                </td>
        </tr>
        <tr>
                <td class="thead" align="center">$vbphrase[department]</td>
                <td class="thead" align="center" nowrap="nowrap">$vbphrase[display_order]</td>
                <td class="thead" align="center">$vbphrase[usergroups]</td>
                <td class="thead" align="center">$vbphrase[manage]</td>
        </tr>
</thead>
<tbody>
        $departments
</tbody>
</table>';

$templates['helpdesk_department'] = '        <form action="helpdesk.php" method="post">
        <input type="hidden" name="s" value="$session[sessionhash]" />
        <input type="hidden" name="do" value="updatedepartment" />
        <input type="hidden" name="departmentid" value="$department[departmentid]" />
        <tr>
                <td class="$bgclass" align="center" width="100%"><input type="text" name="department" class="bginput" value="$department[department]" style="width: 100%;" /></td>
                <td class="$bgclass" align="center"><input type="text" name="displayorder" class="bginput" value="$department[displayorder]" style="width: 100%;" /></td>
                <td class="$bgclass" align="center"><input type="text" name="usergroups" class="bginput" value="$department[usergroups]" style="width: 100%;" /></td>
                <td class="$bgclass" align="center">
                        <input type="submit" class="button" value="$vbphrase[update]" name="update" />
                        <input type="submit" class="button" value="$vbphrase[delete]" name="delete" />
                </td>
        </tr>
        </form>';

// Phrases
$phrase['ticket_reply']['text'] = '  ';
$phrase['ticket_reply']['phrasetypeid'] = 1;

$phrase['reply_to_ticket']['text'] = '  ';
$phrase['reply_to_ticket']['phrasetypeid'] = 1;

$phrase['claim_ownership']['text'] = ' ';
$phrase['claim_ownership']['phrasetypeid'] = 1;

$phrase['unclaim_ownership']['text'] = '  ';
$phrase['unclaim_ownership']['phrasetypeid'] = 1;

$phrase['ticket_tools']['text'] = ' ';
$phrase['ticket_tools']['phrasetypeid'] = 1;

$phrase['resolve_ticket']['text'] = ' ';
$phrase['resolve_ticket']['phrasetypeid'] = 1;

$phrase['unresolve_ticket']['text'] = 'Unresolve Ticket    ';
$phrase['unresolve_ticket']['phrasetypeid'] = 1;

$phrase['edit_ticket']['text'] = ' ';
$phrase['edit_ticket']['phrasetypeid'] = 1;

$phrase['edit_reply']['text'] = ' ';
$phrase['edit_reply']['phrasetypeid'] = 1;

$phrase['delete_ticket']['text'] = ' ';
$phrase['delete_ticket']['phrasetypeid'] = 1;

$phrase['ticket']['text'] = '';
$phrase['ticket']['phrasetypeid'] = 1;

$phrase['helpdesk']['text'] = ' ';
$phrase['helpdesk']['phrasetypeid'] = 1;

$phrase['unresolved_tickets']['text'] = '   ';
$phrase['unresolved_tickets']['phrasetypeid'] = 1;

$phrase['resolved_tickets']['text'] = '  ';
$phrase['resolved_tickets']['phrasetypeid'] = 1;

$phrase['new_ticket']['text'] = ' ';
$phrase['new_ticket']['phrasetypeid'] = 1;

$phrase['unresolved_tickets']['text'] = '   ';
$phrase['unresolved_tickets']['phrasetypeid'] = 1;

$phrase['resolved_tickets']['text'] = '  ';
$phrase['resolved_tickets']['phrasetypeid'] = 1;

$phrase['administer']['text'] = '';
$phrase['administer']['phrasetypeid'] = 1;

$phrase['user_controls']['text'] = ' ';
$phrase['user_controls']['phrasetypeid'] = 1;

$phrase['my_tickets']['text'] = '';
$phrase['my_tickets']['phrasetypeid'] = 1;

$phrase['new_tickets']['text'] = ' ';
$phrase['new_tickets']['phrasetypeid'] = 1;

$phrase['new_replies']['text'] = ' ';
$phrase['new_replies']['phrasetypeid'] = 1;

$phrase['submit_new_ticket']['text'] = '  ';
$phrase['submit_new_ticket']['phrasetypeid'] = 1;

$phrase['last_update_by']['text'] = '{1}  {2}';
$phrase['last_update_by']['phrasetypeid'] = 1;

$phrase['no_unresolved']['text'] = '      .';
$phrase['no_unresolved']['phrasetypeid'] = 1;

$phrase['no_resolved']['text'] = '     .';
$phrase['no_resolved']['phrasetypeid'] = 1;

$phrase['when_logged']['text'] = ' ';
$phrase['when_logged']['phrasetypeid'] = 1;

$phrase['last_update']['text'] = ' ';
$phrase['last_update']['phrasetypeid'] = 1;

$phrase['update']['text'] = '';
$phrase['update']['phrasetypeid'] = 1;

$phrase['no_new_tickets']['text'] = '    .';
$phrase['no_new_tickets']['phrasetypeid'] = 1;

$phrase['no_new_replies']['text'] = '    .';
$phrase['no_new_replies']['phrasetypeid'] = 1;

$phrase['no_tickets_claimed_unresolved']['text'] = '         .';
$phrase['no_tickets_claimed_unresolved']['phrasetypeid'] = 1;

$phrase['no_tickets_unresolved']['text'] = '      .';
$phrase['no_tickets_unresolved']['phrasetypeid'] = 1;

$phrase['claimed_ownership']['text'] = '    .';
$phrase['claimed_ownership']['phrasetypeid'] = 1;

$phrase['unclaimed_ownership']['text'] = '      .';
$phrase['unclaimed_ownership']['phrasetypeid'] = 1;

$phrase['ticket_resolved']['text'] = '     .';
$phrase['ticket_resolved']['phrasetypeid'] = 1;

$phrase['ticket_unresolved']['text'] = '     .';
$phrase['ticket_unresolved']['phrasetypeid'] = 1;

$phrase['ticket_permissions']['text'] = ' ';
$phrase['ticket_permissions']['phrasetypeid'] = 1;

$phrase['department_deleted']['text'] = '  .';
$phrase['department_deleted']['phrasetypeid'] = 1;

$phrase['department_updated']['text'] = '   .';
$phrase['department_updated']['phrasetypeid'] = 1;

$phrase['ticket_deleted']['text'] = '  .';
$phrase['ticket_deleted']['phrasetypeid'] = 1;

$phrase['ticket_updated']['text'] = '  .';
$phrase['ticket_updated']['phrasetypeid'] = 1;

$phrase['departments']['text'] = '';
$phrase['departments']['phrasetypeid'] = 1;

$phrase['department']['text'] = '';
$phrase['department']['phrasetypeid'] = 1;

$phrase['display_order']['text'] = ' ';
$phrase['display_order']['phrasetypeid'] = 1;

$phrase['add_department']['text'] = ' ';
$phrase['add_department']['phrasetypeid'] = 1;

$phrase['department_added']['text'] = '  ';
$phrase['department_added']['phrasetypeid'] = 1;

$phrase['department_update']['text'] = '';
$phrase['department_update']['phrasetypeid'] = 1;

$phrase['usergroup_settings']['text'] = '  ';
$phrase['usergroup_settings']['phrasetypeid'] = 1;

$phrase['can_create_ticket']['text'] = '  ';
$phrase['can_create_ticket']['phrasetypeid'] = 1;

$phrase['can_edit_ticket']['text'] = '  ';
$phrase['can_edit_ticket']['phrasetypeid'] = 1;

$phrase['can_delete_ticket']['text'] = '  ';
$phrase['can_delete_ticket']['phrasetypeid'] = 1;

$phrase['can_resolve_ticket']['text'] = '  ';
$phrase['can_resolve_ticket']['phrasetypeid'] = 1;

$phrase['can_unresolve_ticket']['text'] = '   ';
$phrase['can_unresolve_ticket']['phrasetypeid'] = 1;

$phrase['can_claim_ownership']['text'] = '    ';
$phrase['can_claim_ownership']['phrasetypeid'] = 1;

$phrase['can_unclaim_ownership']['text'] = '     ';
$phrase['can_unclaim_ownership']['phrasetypeid'] = 1;

$phrase['can_edit_any_ticket']['text'] = '   ';
$phrase['can_edit_any_ticket']['phrasetypeid'] = 1;

$phrase['can_delete_any_ticket']['text'] = '   ';
$phrase['can_delete_any_ticket']['phrasetypeid'] = 1;

$phrase['can_resolve_any_ticket']['text'] = '   ';
$phrase['can_resolve_any_ticket']['phrasetypeid'] = 1;

$phrase['can_unresolve_any_ticket']['text'] = '    ';
$phrase['can_unresolve_any_ticket']['phrasetypeid'] = 1;

$phrase['no_guest_in_version']['text'] = '     $vbphrase[helpdesk]   .';
$phrase['no_guest_in_version']['phrasetypeid'] = 1;

$phrase['cannot_delete_last_department']['text'] = '    .';
$phrase['cannot_delete_last_department']['phrasetypeid'] = 1;

$phrase['id']['text'] = 'ID';
$phrase['id']['phrasetypeid'] = 1;

$phrase['helpdesk_auto_response']['text'] = '      .        .';
$phrase['helpdesk_auto_response']['phrasetypeid'] = 3000;
$phrase['helpdesk_auto_response']['subject'] = '$vboptions[bbtitle] Auto Response';

$query['new'][] = "CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "ticketreply` (
  `replyid` int(10) unsigned NOT NULL auto_increment,
  `ticketid` int(10) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `userid` int(10) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  `pagetext` mediumtext NOT NULL,
  `ipaddress` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`replyid`),
  KEY `userid` (`userid`),
  KEY `threadid` (`ticketid`,`userid`)
) TYPE=MyISAM AUTO_INCREMENT=1";

$query['new'][] = "CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "ticket` (
  `ticketid` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(250) NOT NULL default '',
  `open` smallint(6) NOT NULL default '1',
  `ownerid` int(10) unsigned NOT NULL default '0',
  `replycount` int(10) unsigned NOT NULL default '0',
  `postusername` varchar(50) NOT NULL default '',
  `postuserid` int(10) unsigned NOT NULL default '0',
  `lastposter` varchar(50) NOT NULL default '',
  `lastupdate` int(10) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ticketid`),
  KEY `postuserid` (`postuserid`)
) TYPE=MyISAM AUTO_INCREMENT=1";

$query['new'][] = "CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "ticketdepartment` (
  `departmentid` int(10) unsigned NOT NULL auto_increment,
  `department` char(100) NOT NULL default '',
  `displayorder` int(10) unsigned NOT NULL default '0',
  `usergroups` VARCHAR(255) NOT NULL default '',
  UNIQUE KEY `departmentid` (`departmentid`)
) TYPE=MyISAM AUTO_INCREMENT=1";

$query['new'][] = "CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "ticketdeleted` (
  `ticketid` int(10) unsigned NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `departmentid` int(10) unsigned NOT NULL default '0',
  `open` smallint(6) NOT NULL default '1',
  `ownerid` int(10) unsigned NOT NULL default '0',
  `replycount` int(10) unsigned NOT NULL default '0',
  `postusername` varchar(50) NOT NULL default '',
  `postuserid` int(10) unsigned NOT NULL default '0',
  `lastposter` varchar(50) NOT NULL default '',
  `lastupdate` int(10) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ticketid`),
  KEY `postuserid` (`postuserid`)
) TYPE=MyISAM";

$query['new'][] = "ALTER TABLE `".TABLE_PREFIX."ticket` ADD `departmentid` INT(10) UNSIGNED DEFAULT '0' NOT NULL AFTER `title`";

$query['new'][] = "ALTER TABLE `".TABLE_PREFIX."usergroup` ADD `ticketpermissions` INT(10) UNSIGNED DEFAULT '0' NOT NULL";

$settinggroup['helpdesk']['phrase'] = ' ';
$settinggroup['helpdesk']['displayorder'] = '2000';

$setting['helpdesk_switch']['titlephrase'] = ' /  ';
$setting['helpdesk_switch']['descphrase'] = '      ǿ';
$setting['helpdesk_switch']['grouptitle'] = ' ';
$setting['helpdesk_switch']['value'] = '1';
$setting['helpdesk_switch']['defaultvalue'] = '1';
$setting['helpdesk_switch']['optioncode'] = ' ';
$setting['helpdesk_switch']['displayorder'] = '0';

$setting['helpdesk_off_message']['titlephrase'] = '   ';
$setting['helpdesk_off_message']['descphrase'] = '           ɿ';
$setting['helpdesk_off_message']['grouptitle'] = ' ';
$setting['helpdesk_off_message']['value'] = '$vbphrase[helpdesk]   .';
$setting['helpdesk_off_message']['defaultvalue'] = '$vbphrase[helpdesk]   .';
$setting['helpdesk_off_message']['optioncode'] = ' ';
$setting['helpdesk_off_message']['displayorder'] = '10';

$setting['helpdesk_department_access']['titlephrase'] = '     ';
$setting['helpdesk_department_access']['descphrase'] = '           ɿ (Seperated by commas.  Example: 5,6,7)';
$setting['helpdesk_department_access']['grouptitle'] = ' ';
$setting['helpdesk_department_access']['value'] = '5,6,7';
$setting['helpdesk_department_access']['defaultvalue'] = '5,6,7';
$setting['helpdesk_department_access']['optioncode'] = '';
$setting['helpdesk_department_access']['displayorder'] = '20';

$setting['helpdesk_new_tickets']['titlephrase'] = '  ɿ';
$setting['helpdesk_new_tickets']['descphrase'] = '       ɿ';
$setting['helpdesk_new_tickets']['grouptitle'] = ' ';
$setting['helpdesk_new_tickets']['value'] = '1';
$setting['helpdesk_new_tickets']['defaultvalue'] = '1';
$setting['helpdesk_new_tickets']['optioncode'] = ' ';
$setting['helpdesk_new_tickets']['displayorder'] = '30';

$setting['helpdesk_tickets_message']['titlephrase'] = '   ɿ';
$setting['helpdesk_tickets_message']['descphrase'] = '          ɿ';
$setting['helpdesk_tickets_message']['grouptitle'] = ' ';
$setting['helpdesk_tickets_message']['value'] = '$vbphrase[helpdesk]     .';
$setting['helpdesk_tickets_message']['defaultvalue'] = '$vbphrase[helpdesk]     .';
$setting['helpdesk_tickets_message']['optioncode'] = ' ';
$setting['helpdesk_tickets_message']['displayorder'] = '40';

$setting['helpdesk_auto_repsonse']['titlephrase'] = ' ';
$setting['helpdesk_auto_repsonse']['descphrase'] = '            ǿ';
$setting['helpdesk_auto_repsonse']['grouptitle'] = ' ';
$setting['helpdesk_auto_repsonse']['value'] = '0';
$setting['helpdesk_auto_repsonse']['defaultvalue'] = '0';
$setting['helpdesk_auto_repsonse']['optioncode'] = '<select name=\"setting[$setting[varname]]\" tabindex=\"1\" class=\"bginput\">
<option value=\"0\" " . iif($setting[\'value\']==0,\'selected="selected"\') . ">$vbphrase[none]</option>
<option value=\"1\" " . iif($setting[\'value\']==1,\'selected="selected"\') . ">$vbphrase[private_message]</option>
<option value=\"2\" " . iif($setting[\'value\']==2,\'selected="selected"\') . ">$vbphrase[email]</option>
</select>';
$setting['helpdesk_auto_repsonse']['displayorder'] = '50';




// ######################### Start the install #######################
if ($step == '0')
{
        echo "<p><b>       ".VERSION."      (  ).</b><p>";
        echo "<a href=helpdesk_install.php?do=install&step=1> 1:  </a><br />";
        echo "<a href=helpdesk_install.php?do=install&step=2> 2:   </a><br />";
        echo "<a href=helpdesk_install.php?do=install&step=3> 3:  </a><br />";
        echo "<a href=helpdesk_install.php?do=install&step=4> 4:   </a><br />";
        echo "<a href=helpdesk_install.php?do=install&step=5> 5:  </a>";
        echo "<a href=helpdesk_install.php?do=install&step=6> 6:  </a>";
        echo "<p><a href=\"helpdesk_install.php?do=install&step=1\"><b>     --&gt;</b></a></p><br>\n";

        echo "<p><b>     ".VERSION.".</b><p>";
        echo "<a href=helpdesk_install.php?do=upgrade&step=1> 1:  /  </a><br />";
        echo "<a href=helpdesk_install.php?do=upgrade&step=2> 2:  .</a><br />";
        echo "<a href=helpdesk_install.php?do=upgrade&step=3> 3:  </a><br />";
        echo "<a href=helpdesk_install.php?do=upgrade&step=4> 4:   </a><br />";
        echo "<a href=helpdesk_install.php?do=upgrade&step=5> 5:  </a>";
        echo "<p><a href=\"helpdesk_install.php?do=upgrade&step=1\"><b>     --&gt;</b></a></p><br>\n";

        echo "<p><b>   </b><p>";
        echo "<a href=helpdesk_install.php?do=uninstall&step=1> 1:  </a><br />";
        echo "<a href=helpdesk_install.php?do=uninstall&step=2> 2:  </a><br />";
        echo "<a href=helpdesk_install.php?do=uninstall&step=3> 3:     </a><br />";
        echo "<a href=helpdesk_install.php?do=uninstall&step=4> 4:  </a>";
        echo "<p><a href=\"helpdesk_install.php?do=uninstall&step=1\"><b>     --&gt;</b></a></p><br>\n";
}

if ($step == 1)
{
        if ($_REQUEST['do'] == 'install')
        {
                foreach ($phrase as $varname => $ph) {
                        insert_phrase($varname, $ph['text'], $ph['phrasetypeid']);
                }

                build_language(-1);

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=install&step=2\"><b>      --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'upgrade')
        {
                echo " ... <br /><Br />";

                foreach ($templates as $name => $content) {
                        insert_template($name, $content);
                }

                build_all_styles(0, 0, "helpdesk_install.php?$session[sessionurl]do=upgrade&step=2");

        }
        else if ($_REQUEST['do'] == 'uninstall')
        {
                echo " ... <br /><Br />";

                foreach ($templates as $name => $content) {
                        kill_template($name);
                }

                build_all_styles(0, 0, "helpdesk_install.php?$session[sessionurl]do=uninstall&step=2");

        }
}

if ($step == 2)
{
        if ($_REQUEST['do'] == 'install')
        {
                echo " ... <br /><br />";

                foreach ($templates as $name => $content) {
                        insert_template($name, $content);
                }

                build_all_styles(0, 0, "helpdesk_install.php?$session[sessionurl]do=install&step=3");
        }
        else if ($_REQUEST['do'] == 'upgrade')
        {
                foreach ($phrase as $varname => $ph) {
                        insert_phrase($varname, $ph['text'], $ph['phrasetypeid']);
                }

                build_language(-1);

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=upgrade&step=3\"><b>     --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'uninstall')
        {
                echo " ... <br /><Br />";
                foreach ($phrase as $varname => $ph) {
                        kill_phrase($varname);
                }

                build_language(-1);

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=uninstall&step=3\"><b>     --&gt;</b></a><br /><br />\n";
        }
}

if ($step == 3)
{
        if ($_REQUEST['do'] == 'install')
        {
                echo " <br /><br />";

                foreach ($settinggroup as $group => $sg) {
                        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "settinggroup (grouptitle, displayorder, volatile) VALUES ('$group', '$sg[displayorder]', '0')");
                        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0',  'settinggroup_".$group."', '$sg[phrase]', '5000')");
                        echo "<font size=\"1\"> <i>".$sg['phrase']."</i>  </font><br /><br />";
                }

                foreach ($setting as $varname => $set) {
                        insert_setting($set['titlephrase'], $set['descphrase'], $varname, $set['grouptitle'], $set['value'], $set['defaultvalue'], $set['optioncode'], $set['displayorder']);
                }

                require_once('./includes/adminfunctions.php');
                build_options();

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=install&step=4\"><b>     --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'upgrade')
        {
                echo " <br /><br />";

                foreach ($settinggroup as $group => $sg) {
                        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "settinggroup (grouptitle, displayorder, volatile) VALUES ('$group', '$sg[displayorder]', '0')");
                        $DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0',  'settinggroup_".$group."', '$sg[phrase]', '5000')");
                        echo "<font size=\"1\"> <i>".$sg['phrase']."</i>  </font><br /><br />";
                }

                foreach ($setting as $varname => $set) {
                        insert_setting($set['titlephrase'], $set['descphrase'], $varname, $set['grouptitle'], $set['value'], $set['defaultvalue'], $set['optioncode'], $set['displayorder']);
                }

                require_once('./includes/adminfunctions.php');
                build_options();

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=upgrade&step=4\"><b>    --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'uninstall')
        {
                echo "<br /> !<br /><br />";
                $DB_site->query("DROP TABLE " . TABLE_PREFIX . "ticket");
                $DB_site->query("DROP TABLE " . TABLE_PREFIX . "ticketdeleted");
                $DB_site->query("DROP TABLE " . TABLE_PREFIX . "ticketreply");
                $DB_site->query("DROP TABLE " . TABLE_PREFIX . "ticketdepartment");
                $DB_site->query("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP ticketpermissions");

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=uninstall&step=4\"><b>     --&gt;</b></a><br /><br />\n";
        }
}

if ($step == 4)
{
        if ($_REQUEST['do'] == 'install')
        {
                echo "<br /> !<br /><br />";
                foreach ($query as $build => $querie) {
                        foreach ($querie as $i => $querieie) {
                                $DB_site->query($querieie);
                        }
                }
                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=install&step=5\"><b>     --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'upgrade')
        {
                echo "<br /> !<br /><br />";
                foreach ($query as $build => $querie) {
                        foreach ($querie as $i => $querieie) {
                                $DB_site->query($querieie);
                        }
                }
                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=upgrade&step=5\"><b>    --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'uninstall')
        {
                echo "<br /> !<br /><br />";

                foreach ($settinggroup as $group => $sg) {
                        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "settinggroup WHERE grouptitle = '$group'");
                        $DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'settinggroup_".$group."'");
                        echo "<font size=\"1\"> <i>".$sg['phrase']."</i>  </font><br /><br />";
                }

                foreach ($setting as $varname => $set) {
                        kill_setting($varname);
                }

                require_once('./includes/adminfunctions.php');
                build_options();

                echo "<br /> !<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=uninstall&step=5\"><b>    --&gt;</b></a><br /><br />\n";
        }
}

if ($step == 5)
{
        if ($_REQUEST['do'] == 'install')
        {
                echo "<b>:</b> navbar<br /><br /><b> :</b><br /><textarea style=\"height: 100px; width: 100%;\"><td class=\"vbmenu_control\"><a href=\"calendar.php?\$session[sessionurl]\">\$vbphrase[calendar]</a></td></textarea><br /><br /><b> :</b><br /><textarea style=\"height: 100px; width: 100%;\">                <td class=\"vbmenu_control\"><a href=\"helpdesk.php?\$session[sessionurl]\">\$vbphrase[helpdesk]</a></td></textarea><br /><Br />";
                echo "<a href=\"helpdesk_install.php?do=install&step=6\"><b>     --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'upgrade')
        {
                echo "<br /><b> </b><br />1.     (AdminCP -> vBulletin Options -> HelpDesk)<br />2.         . (www.yoursite.com/helpdesk.php?do=departments)<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=upgrade&step=6\"><b>    --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'uninstall')
        {
                echo "<br /> .    !<br /><br />";
        }
}

if ($step == 6)
{
        if ($_REQUEST['do'] == 'install')
        {
                echo "<br /><b> </b><br />1.     (AdminCP -> vBulletin Options -> HelpDesk)<br />2.         . (www.yoursite.com/helpdesk.php?do=departments)<br /><br />";
                echo "<a href=\"helpdesk_install.php?do=install&step=7\"><b>    --&gt;</b></a><br /><br />\n";
        }
        else if ($_REQUEST['do'] == 'upgrade')
        {
                echo "<br /> .    !<br /><br />";
        }
}

if ($step == 7)
{
        if ($_REQUEST['do'] == 'install')
        {
                echo "<br /> .    !<br /><br />";
        }
}

print_cp_footer();

?>